# How to build the MSU files

## Get the soundtrack
The soundtrack is available in several places for just $12:
https://store.steampowered.com/app/3928720/Hollow_Knight_Silksong__Official_Soundtrack/
https://www.gog.com/en/game/hollow_knight_silksong_ost
https://christopherlarkin.bandcamp.com/album/hollow-knight-silksong-original-soundtrack

## Extract the files
Extract the .zip file with the msu files somewhere. You may have already done
this to get this far, but it won't work if you try to run it from the archive
directly.

## Copy the soundtrack files into the extracted folder
If you bought the soundtrack from Steam and installed it in the default C:\
library, you can skip this step.

Otherwise, copy the files from the soundtrack into the OST folder. Make sure you
get the FLAC versions if it came with both (MP3s not guaranteed to work
properly). Your extracted folder should look like this:

```
OST
    /01 Enter Pharloom.flac
    /02 Moss Grotto.flac
    ...
    /53 Silksong.flac
!Swap_Alt_Tracks.bat
msupcm.exe
README.md
silksong-8.pcm
silksong-14.pcm
silksong-19.pcm
silksong-19_alt.pcm
silksong-30.pcm
silksong.msu
silksong.yml
Track List.txt
tracks.json
tracks-local.json
```

Delete the tracks.json file and rename tracks-local.json to tracks.json ONLY if
you copied the files into the OST directory.

## Run msupcm.exe
Double-click on msupcm.exe to build all the .pcm files. If it doesn't work, try
right-clicking inside the folder and selecting "Open in Terminal", then typing
`msupcm.exe` and pressing Enter. This will show any error messages that might
help diagnose the problem.

## (Optional) Swap alternate tracks
If you hate Sherma and love Shakra, you can swap to the alternate fanfare track
by using the provided `!Swap_Alt_Tracks.bat` file. This will replace the
original track with the alternate version.

## Play the game
Copy all of the silksong-*.pcm files and the silksong.msu file to a folder in
your sdcard, or to wherever you keep your other MSU files.
